//ext3_interrupt_demo1.c
//part 1: header//////////////////////////////////////////////
#include <lpc21xx.h>
#define D1_red_led 0x400 //p0.10=D1_red_led
#define D2_green_led 0x800 //p0.11=D2_green_led
//define global variables
long timeval;
long excount;
void init_Eint (void);
void simple_delay_loop(void);


//part 2 -ISR Interrupt service routine,put this before main() 
void __irq isr_Eint3()
{    excount++;
    //Toggle the Green LED by pressing SW3
    if((excount%2)==0) {
 	IO0CLR|=D2_green_led; //OFF GREEN LED
	excount = 0;
     }
     else IO0SET|=D2_green_led; //ON GREEN LED
     EXTINT = 0x08;	    // Clear EINT3 flag
     VICVectAddr = 0;     // Acknowledge Interrupt   
}
// part 3 ///////  initialize  interrupt ////////////
void init_Eint (void){
	EXTMODE=0x08; // EINT3 is edge triggered
	VICVectAddr1 = (unsigned long)isr_Eint3;  
	// set interrupt vector in 1
	VICVectCntl1 = 0x20 | 17;// use EINT3 intp
	VICIntEnable |= 0x00020000;//Enable EINT3
	EXTINT = 0x08;  // Clear EINT3 flag
}
// part 4/simple_delay_loop//////////////////////
void simple_delay_loop(void) {
	int i,k,delay_count;
	delay_count  = 900000;
//change delay_count to see how it affects delay time
	for (i = 0; i < delay_count; i++)
	{	k++;
	}
}
/// part 5 /////////////// main () program //////////////////
int  main(void) //place main() at the end of the program
{
  PINSEL1 |= 0x00000300; 
  // set p0.20=EINT3 external 
  //interrupt input
  init_Eint();// Init External Interrupt
  IO0DIR|=D1_red_led;
  IO0DIR|=D2_green_led;
  while(1) {
            // Off Red LED/////////////
	IO0CLR|=D1_red_led;	
	simple_delay_loop();

	// On Red LED////////////
	IO0SET|=D1_red_led;	
	simple_delay_loop();
      }
}
