addpath(genpath('utils'));

data_path       = 'demo_test_images';
scale_factor    = 4;

%% read input images
filenames   = dir(fullfile(data_path, '*.png'));
num_imgs    = length(filenames);
img_list    = cell(num_imgs, 1);
for iimg = 1 : num_imgs
    img_list{iimg} = im2double(imread(fullfile(data_path, filenames(iimg).name)));
end

%% generate sr drafts
load flow_params
num_drafts  = numel(flow_params) + 1;
draft_list  = cell(num_drafts, 1);
for idraft = 1 : num_drafts - 1
    draft_list{idraft} = dsr_gen_sr_draft(img_list, scale_factor, flow_params(idraft));
end
ref_idx = ceil(num_imgs / 2);
img_bic = dsr_imresize(img_list{ref_idx}, size(img_list{ref_idx}) * scale_factor, 'bicubic');
draft_list{num_drafts} = img_bic;

%% draft ensemble using CNN
load cnn_model
img_ours    = dsr_draft_ensemble(draft_list, cnn_model);

%% show results
figure;     imshow(img_bic);    title('Bicubic');
figure;     imshow(img_ours);   title('Ours');
